/*
Programm par Maniack Crudelis.
http://www.crudelis.fr.tc
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
*/

#ifndef FICHIER_H
#define FICHIER_H

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>
#include <string.h>
#include "Utilitaire.h"
#include "Chaines.h"


FILE* ouvre_fichier (const char* chemin, const char mode[]);   //Gre les erreur sur l'ouverture de fichier

void listing_doss (const char* nomdossier, FILE* sortie, int recurs, const char* filtres, int printdir); //Liste un dossier et imprime le rsultat dans le fichier sortie (En ralite cette fonction gre le filtre de fichier et appelle print_doss)
void print_doss (const char* nomdossier, FILE* sortie, int recurs, char tabfiltre[255][255], int nbfiltres, int printdir); //Fonction soujacente  listing_doss qui s'occupe de l'exploration du dossier et de l'affichage


FILE* ouvre_fichier (const char* chemin, const char mode[])
{
    FILE* fichier;
    char* chemin_acc;
    ER = (int) (chemin_acc = (char*) calloc(strlen(chemin)*2,sizeof(char)));  //Alloc dynamique sur chemin_acc de la taille de chemin (*2 pour la gestion des accents
    Erreur(1);
    #ifdef WIN32    //win
    strcpy(chemin_acc,invers_acc(chemin,chfunc)); //Corrige les accents pour windows
    #else /*linux*/
    strcpy(chemin_acc,linux_acc(chemin,chfunc));    //Corrige les accents pour linux
    #endif
    changeslash(chemin_acc);    //Inerse les slash pour linux (le cas chant)
    if ((fichier = fopen (chemin_acc,mode)) == NULL)    /*Ouvre le fichier*/
    {
        #ifdef WIN32    //win
        printf("\n!!! Une erreur est survenue durant l'ouverture du fichier %s, en mode %s", acc(chemin_acc,chfunc), mode);
        #else   //linux
        printf("\n!!! Une erreur est survenue durant l'ouverture du fichier %s, en mode %s", chemin_acc, mode); //Les accents ont dj t modifi pour l'affichage linux
        #endif
        free(chemin_acc);
        Pause();                /*Envoie un message d'erreur  l'utilisateur*/
        exit(1);                /*Puis quitte le programme*/
    }
    else
    {
        free(chemin_acc);
        return (fichier);        /*Envoie le pointeur de fichier si pas d'erreur d'ouverture*/
    }
}

void listing_doss (const char* nomdossier, FILE* sortie, int recurs, const char* filtres, int printdir)
{
/*nomdossier est le dossier  lister
sortie est le fichier o sera aficher le listing
recurs  1 pour un listing rcursif, sinon  0
filtres permet d'affecter 1 ou plusieurs filtres de fichiers. De la manire suivante: txt:html:txtp, pour n'utiliser aucun filtres, noter une chaine vide
printdir  1 pour lister galement les dossiers, sinon  0*/
    char tabfiltre[255][255];   //Cre un tableau capable de supporter 255 filtres diffrents (a devrait suffire)
    int nbfiltres=0, i;
    char constfiltres[255]; //L'utilisation d'une variable locale vite une erreur qui me dpasse,
    strcpy(constfiltres,filtres);   //lors de l'appel du strcpy de Efface_char en cas d'argument envoy en const
    if(constfiltres[0] != '\0')  //Si il y a des filtres de fichiers
    {
        do
        {
            strcpy(tabfiltre[nbfiltres],constfiltres);   //Copie l'ensemble de la chaine de filtre  la suite du tableau
            if(strstr(constfiltres,":")) //Si il y un :, donc d'autres filtres
            {
                i = index_ch_first(constfiltres,":");  //Repre l'index du premier :
                tabfiltre[nbfiltres][i] = '\0'; //Termine le filtre dans le tableau au :
                Efface_char(constfiltres,":");   //Coupe dans la chaine de filtres, le filtre qui vient d'tre copi
            }
            else
                i=-1;
            if(tabfiltre[nbfiltres][0] == '*')
                Efface_char(tabfiltre[nbfiltres],"*");  //Efface l'* du dbut de type si il est prsent
            if(tabfiltre[nbfiltres][0] == '.')
                Efface_char(tabfiltre[nbfiltres],".");  //Efface le . du dbut de type si il est prsent
            nbfiltres++;    //Un filtre lu
        }while(i!=-1);    //Tant qu'il reste des filtres
    }
    print_doss(nomdossier,sortie,recurs,tabfiltre,nbfiltres,printdir);  //Appel la fonction print_doss qui s'occupera du listing et de l'affichage
}

void print_doss (const char* nomdossier, FILE* sortie, int recurs, char tabfiltre[255][255], int nbfiltres, int printdir)
{
    DIR* doss;   //Dclaration de variable de type rpertoire
    struct dirent *lecture;   //Dclare la structure recevant la lecture de readdir, dtail du fichier lu
    struct stat s;	//Dclare la structure pour stat, permettant l'identification des dossiers
    char chaine[4096];
    char* local_nomdossier;
    char* nom_complet;
    int i, fok;
    ER = (int) (local_nomdossier = (char *)malloc(strlen(nomdossier)*2));
    Erreur(1);
    #ifdef WIN32    //win
    strcpy(local_nomdossier,nomdossier);
    #else //linux
    strcpy(local_nomdossier,linux_acc(nomdossier,chfunc));    //Corrige les accents pour linux
    #endif
    changeslash(local_nomdossier);    //Inerse les slash pour linux (le cas chant)
    if ((doss = opendir(local_nomdossier)) == NULL)    /*Ouvre le dossier*/
    {
        printf("\n!!! Une erreur est survenue durant l'ouverture du dossier %s.\n", local_nomdossier);
        Pause();                /*Envoie un message d'erreur  l'utilisateur*/
        exit(1);                /*Puis quitte le programme*/
    }
    while ((lecture = readdir(doss)))   //Lit le contenu du dossier et test la fin du listing (readdir != NULL)
    {
        fok=1;  //Par dfaut le filtre est ok
        if (strcmp (lecture->d_name, ".") != 0 && strcmp (lecture->d_name, "..") != 0)  //N'affiche pas . et ..
        {
            if(nbfiltres)   //Si il existe des filtres
                fok=0; //Pour application du filtre, il devra explicitement autoriser.
            ER = (int) (nom_complet = (char *)malloc(strlen(local_nomdossier)+strlen(lecture->d_name)+3));
            Erreur(1);
            #ifdef WIN32    //win
            sprintf (nom_complet,"%s\\%s", local_nomdossier, lecture->d_name);    //Ecrit dans la chaine, nomdossier puis la lecture
            #else//linux
            sprintf (nom_complet,"%s/%s", local_nomdossier, lecture->d_name);    //Ecrit dans la chaine, nomdossier puis la lecture
            #endif
            if(stat(nom_complet,&s) == -1)  //Appel le fonction stat, qui va rcolter des informations sur le fichier donn
            {   //Et test sa bonne excution
                perror("Erreur interne lors de l'appel de la fonction stat");
                printf("Dossier en cours: %s\n",nom_complet);
                free(nom_complet);
                free(local_nomdossier);
                Pause();
                exit(1);
            }
            if(recurs)
            {   //Si recurs n'est pas  0, la commande de rcursivit est demande
                if(S_ISDIR(s.st_mode) == 1) //Si 1, alors c'est un dossier, si 0 c'est un fichier
                    print_doss(nom_complet,sortie,recurs,tabfiltre,nbfiltres,printdir);  //Rappelle la fonction en rcursif pour explorer le nouveau dossier trouv
            }
            free(nom_complet);
            if(nbfiltres)   //Si nbfiltres > 0, prsence de filtres de fichiers
            {
                if(strstr(lecture->d_name,".")) //Si ., donc extension de fichier, application du filtre. A noter que sans extension, il restera  fok=0!
                {
                    strcpy(chaine,strrchr(lecture->d_name,'.')); //Copie seulement  partir du .
                    Efface_char(chaine,".");    //Efface le point
                    for(i=0;i<nbfiltres;i++)    //Boucle sur l'ensemble des filtres
                    {
                        if(strcmp(chaine,tabfiltre[i]) == 0)    //Si l'extension correspond  un des filtres
                        {
                            fok=1;  //Fichier ok
                            break;  //Break pour viter de perdre du temps inutilement.
                        }
                    }
                }
            }
            if(!printdir && S_ISDIR(s.st_mode))    //printdir  0, dossiers non list, et prsence d'un dossier
                fok=0;  //Annule l'affichage du dossier
            if(fok) //Affiche seulement si le filtre est ok
                #ifdef WIN32    //win
                fprintf(sortie,"%s\\%s\n", local_nomdossier,lecture->d_name);   //Affiche le nom lu lors du listing
                #else//linux
                fprintf(sortie,"%s/%s\n", local_nomdossier,lecture->d_name);   //Affiche le nom lu lors du listing
                #endif
        }
    }
    closedir(doss); //Ferme le dossier
    free(local_nomdossier);
}

#endif
